const cookieModalElement = `
<!-- Button trigger modal -->
<button id="cookieModalBtn" type="button" class="btn btn-primary" data-toggle="modal" data-target="#cookieModal">
</button>
<!-- Modal -->
<div class="privacy-style-modal modal fade" id="cookieModal" tabindex="-1" role="dialog"
     aria-labelledby="cookieModalLabel" data-backdrop="static" data-keyboard="false"
     aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-scrollable" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="cookieModalLabel">Data Privacy / Cookie Statement</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
        <div class="container-fluid">
            <div class="row about_row">
                <div class="container px-4 mb-20 text-20 text-justify">

                    <div class="row">
                        <ul>
                            <li class="mb-4">Globus Bank Limited of Plot 722 Akinbo Savage, Victoria Island, Lagos
                                State, Nigeria, is a data controller under the Nigeria Data Protection Act 2023 and
                                Nigeria Data Protection Regulation 2019.
                            </li>
                            <li class="mb-4">
                                Globus Bank Limited will process the information you provide online or on the account
                                opening forms (individual or corporate), as well as data obtained from other legitimate
                                sources in accordance with our Privacy Policy.
                            </li>
                        </ul>
                    </div>

                    <div class="row">
                        <ul class="mb-4 shifted-list">
                            <p class="mb-3">We will use your information to:</p>
                            <li><span class="mr-2">•</span>Create and manage your account
                            </li>
                            <li><span class="mr-2">•</span>Provide, communicate, and administer our services and events,
                                including sending promotional materials, newsletters, and other marketing
                                communications.
                            </li>
                            <li><span class="mr-2">•</span>Offer customer support and maintain our relationship with
                                you.
                            </li>
                            <li><span class="mr-2">•</span>Verify your identity and protect against fraud, unauthorized
                                transactions, and other unlawful activities.
                            </li>
                        </ul>
                    </div>
                    <div class="row">
                        <ul>
                            <li class="mb-4">For a full list of purposes and legal bases for processing, please refer to
                                our Privacy Policy on our website at <a href="./PrivacyPolicy.html">Privacy Policy</a>
                            </li>
                            <li class="mb-4">
                                We may share information about you and your transactions as permitted by law for
                                purposes such as national security and improving our services. However, your personal
                                information will not be shared with third parties for their marketing purposes. We may
                                also disclose your information if necessary to enforce our terms and conditions or
                                protect our operations and users.
                            </li>
                            <li class="mb-4">
                                In the event of a reorganization, merger, or sale, we may transfer your personal
                                information to the relevant data controller. If any data transfers involve recipients
                                outside Nigeria, we will take appropriate measures to ensure compliance with the
                                applicable data protection laws
                            </li>
                            <li>
                                We use cookies and similar technologies that are necessary to operate the website. Additional
                                cookies are only used with your consent. By continuing to use this website, you automatically accept
                                our Privacy and Data Protection Policies. <br><br>
                                For any questions, comments, or requests regarding data privacy, please contact our Data Protection Officer:
                                <br>📧 Email: dpo@globusbank.com 📞 Tel: 02014661000, 02012259000
                            </li>
                        </ul>
                    </div>
                </div>

            </div>
        </div>
            </div>  
            <div class="modal-footer" style="display: unset">
                <button data-dismiss="modal" onclick="acceptCookie()" type="button" class="btn btn-primary text-white">Accept & Continue</button>
                <button data-dismiss="modal" type="button" class="btn btn-danger text-white">Close</button>
            </div>
        </div>
    </div>
</div>`

async function loadCookieModal() {
    const div = document.createElement("div")
    div.innerHTML = cookieModalElement;
    document.body.appendChild(div);
}

confirmCookie().then(r => {
    console.info("confirming cookies...")
}).catch(er => {
    console.error("er", er)
});

function acceptCookie() {
    setCookie("cookie-consent-settings", "necessary=true", 365)
}

async function getCookie(cname) {
    let name = cname + "=";
    const cookie = await cookieStore.get("cookie-consent-settings")
    if (cookie === null) {
        return ""
    }
    const expires = cookie.expires
    const value = cookie.value
    let decodedCookie = decodeURIComponent(value);
    let ca = decodedCookie.split(';');
    for (let i = 0; i < ca.length; i++) {
        let c = ca[i];
        while (c.charAt(0) == ' ') {
            c = c.substring(1);
        }
        if (c.indexOf(name) == 0) {
            return {value: c.substring(name.length, c.length), expires: expires};
        }
    }
    return {value: "", expires: expires};
}

function setCookie(cname, cvalue, exdays) {
    const d = new Date();
    d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
    let expires = "expires=" + d.toUTCString();
    document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
}

async function confirmCookie() {
    const isCookie = await getCookie("necessary")
    const d = new Date()
    const tOffset = d.getTimezoneOffset() * 60000
    const offsetTime = new Date().setTime(isCookie.expires + tOffset)
    if (isCookie.value !== 'true' || offsetTime < d.getTime()) {
        await loadCookieModal();
        window.onload = function () {
            document.getElementById('cookieModalBtn').click();
        }
    }
    return isCookie
}

window.addEventListener('resize', () => {
    let vh = window.innerHeight * 0.01;
    document.documentElement.style.setProperty('--vh', `${vh}px`);
});

function openTabs(cityName, elmnt, color) {
    var i, tabcontent, tablinks;
    tabcontent = document.getElementsByClassName("tabcontent");
    for (i = 0; i < tabcontent.length; i++) {
        tabcontent[i].style.display = "none";
    }
    tablinks = document.getElementsByClassName("tablink");
    for (i = 0; i < tablinks.length; i++) {
        tablinks[i].style.backgroundColor = "";
    }
    document.getElementById(cityName).style.display = "block";
    elmnt.style.backgroundColor = color;
}

// document.getElementById("defaultOpen").click();


function openAboutLinks(cityName, elmnt, color, border, fontweight) {
    var i, tabcontent, tablinks;
    tabcontent = document.getElementsByClassName("tabcontent");
    for (i = 0; i < tabcontent.length; i++) {
        tabcontent[i].style.display = "none";
    }
    tablinks = document.getElementsByClassName("tablink");
    for (i = 0; i < tablinks.length; i++) {
        tablinks[i].style.backgroundColor = "";
        tablinks[i].style.borderBottom = "";
        tablinks[i].style.fontWeight = "";
    }
    document.getElementById(cityName).style.display = "block";
    elmnt.style.backgroundColor = color;
    elmnt.style.borderBottom = border;
    elmnt.style.fontWeight = fontweight;

}

// Get the element with id="defaultOpen" and click on it
// document.getElementById("defaultOpen").click();


// function openAccountLinks(cityName,elmnt,color, border) {
//   var i, tabcontent, tablinks;
//   tabcontent = document.getElementsByClassName("tabcontentt");
//   for (i = 0; i < tabcontent.length; i++) {
//     tabcontent[i].style.display = "none";
//   }
//   tablinks = document.getElementsByClassName("tablink-account");
//   for (i = 0; i < tablinks.length; i++) {
//     tablinks[i].style.backgroundColor = "";
//     tablinks[i].style.borderBottom = "";
//   }
//   document.getElementById(cityName).style.display = "block";
//   elmnt.style.backgroundColor = color;
//   elmnt.style.borderBottom = border;
// }
// document.getElementById("defaultOpenAccount").click();

//For the top active navigation link

var topNav = document.getElementById("top-nav");
var navlinks = topNav.getElementsByClassName("nav-1");
for (var i = 0; i < navlinks.length; i++) {
    navlinks[i].addEventListener("click", function () {
        var current = document.getElementsByClassName("active-nav");
        if (current.length > 0) {
            current[0].className = current[0].className.replace(" active-nav", "");
        }
        this.className += " active-nav";
    });
}

// For the about us accordion
function accordionPage() {
    var coll = document.getElementsByClassName("collapsible");
    var i;

    for (i = 0; i < coll.length; i++) {
        coll[i].addEventListener("click", function () {
            this.classList.toggle("active-about");
            var content = this.nextElementSibling;
            if (content.style.maxHeight) {
                content.style.maxHeight = null;
            } else {
                content.style.maxHeight = content.scrollHeight + "px";
            }
        });
    }
}

function openNav() {
    if (document.getElementById("myNav").style.width !== "100%") {
        document.getElementById("myNav").style.width = "100%";
        document.getElementById("top-mobile-header").style.display = "none!important";
    } else {
        document.getElementById("myNav").style.width = "0%";
        document.getElementById("top-mobile-header").style.display = "block";
    }
    // document.getElementById("top-mobile-header").style.position = "unset!important";
    // document.getElementById("top-mobile-header").style.top = "0";
    // document.getElementById("top-mobile-header").style.right = "0";
    // document.getElementById("top-mobile-header").style.left = "0";
    // document.getElementById("top-mobile-header").style.zIndex = "0!important";
}

function closeNav() {
    document.getElementById("myNav").style.width = "0%";
    document.getElementById("top-mobile-header").style.display = "block";
    // document.getElementById("top-mobile-header").style.width = "100%";
    // document.getElementById("top-mobile-header").style.position = "fixed";
    // document.getElementById("top-mobile-header").style.top = "0";
    // document.getElementById("top-mobile-header").style.right = "0";
    // document.getElementById("top-mobile-header").style.left = "0";
    // document.getElementById("top-mobile-header").style.zIndex = "1030";
}

/* Loop through all dropdown buttons to toggle between hiding and showing its dropdown content - This allows the user to have multiple dropdowns without any conflict */

var dropdown = document.getElementsByClassName("dropdown-btn");
var i;

for (i = 0; i < dropdown.length; i++) {
    dropdown[i].addEventListener("click", function () {
        this.classList.toggle("active");
        var dropdownContent = this.nextElementSibling;
        if (dropdownContent.style.display === "block") {
            dropdownContent.style.display = "none";
        } else {
            dropdownContent.style.display = "block";
        }
    });
}

var header = document.getElementById('top-nav');
var links = header.getElementsByClassName('nav_link');

// alert(window.location.href)
for (var i = 0; i < links.length; i++) {
    links[i].addEventListener("click", function () {
        // alert(window.location.href)
        var current = document.getElementsByClassName("activee");
        current[0].className = current[0].className.replace(" activee", "");
        this.className += " activee";
    });
}

// const observerOptions = {
//   threshold: '0.3',
//   rootMargin: ''
// }

// const observer = new MutationObserver(handleObservation, observerOptions);
const allScrollDownArrows = document.querySelectorAll('.scrolling_down_arrow_container');
allScrollDownArrows.forEach(scrollDownArrow => {
    scrollDownArrow.addEventListener('click', (e) => {
        const nextElement = scrollDownArrow.nextElementSibling;
        const elementAtTheTop = scrollDownArrow.closest('.site-sub-main').querySelector('.first_section');
        const targetElement = e.target;
        if (targetElement.classList.contains('rotate_up')) {
            elementAtTheTop.scrollIntoView({behavior: "smooth", block: 'start', inline: "nearest"});
        } else {
            nextElement.scrollIntoView({behavior: "smooth", inline: "nearest"});
        }
        targetElement.classList.toggle('rotate_up');
    })
})

