async function getBase64(file) {
	return new Promise((resolve, reject) => {
		const reader = new FileReader();
		reader.readAsDataURL(file);
		reader.onload = () => resolve(reader.result);
		reader.onerror = error => reject(error);
	});
}

$(function () {

	$("#username_error_message").hide();
	// $("#password_error_message").hide();
	// $("#retype_password_error_message").hide();
	$("#email_error_message").hide();

	$("#phone_error_message").hide();

	var error_username = false;
	// var error_password = false;
	// var error_retype_password = false;
	var error_email = false;

	$("#form_name").focusout(function () {

		// check_username();

	});

	$("#form_phone").focusout(function () {

		// check_phone();

	});

	$("#form_email").focusout(function () {

		// check_email();

	});


	// $("#form_message").focusout(function() {

	// 	check_message();

	// });

	function check_username() {

		var username_length = $("#form_name").val().length;

		if (username_length < 5 || username_length > 20) {
			$("#username_error_message").html("Should be between 5-20 characters");
			$("#username_error_message").show();
			error_username = true;
		} else {
			$("#username_error_message").hide();
		}

	}


	function check_phone() {

		var phone_length = $("#form_phone").val().length;

		if (phone_length < 5 || phone_length > 20) {
			$("#phone_error_message").html("Please enter a valid number");
			$("#phone_error_message").show();
			error_phone = true;
		} else {
			$("#phone_error_message").hide();
		}

	}

	function complete() {

		setTimeout(function () {
			$('.alert').addClass('show');
			$('#mybtn').hide();
			$('#registration_form').trigger("reset");
		}, 1500);

	}

	function notify() {

	}

	function check_email() {

		var pattern = new RegExp(/^[+a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}$/i);

		if (pattern.test($("#form_email").val())) {
			$("#email_error_message").hide();
		} else {
			$("#email_error_message").html("Invalid email address");
			$("#email_error_message").show();
			error_email = true;
		}

	}


	$("#close-form-error").on("click", (e) => {
		$("#form-error-alert").css("display", "none");
	})
});
